import sys

def dumpCompo(line, indents, file):
	for i in range(indents):
		file.write('  ')
	file.write('* ')
	file.write(line)
	file.write('\n')
	
def compoAndLicenses(compo, *args):
	return compo + ': ' + ', '.join(args)
	
lgpl2 = 'LGPL 2'
apple = 'Apple License'
lgpl21 = 'LGPL 2.1'
icu = 'ICU License'
zlib = 'zlib License'
curl = 'CUrl License'
mit = 'MIT License'
libjpeg = 'libJpeg License'
libpng = 'libPng License'
includeRendererItself = sys.argv[1] != False
with open('result.txt', 'a') as f:
	indent = 1
	if includeRendererItself:
		dumpCompo(compoAndLicenses('SVGRenderer', lgpl2), indent, f)
		indent = indent + 1
	
	dumpCompo(compoAndLicenses('JavaScriptCore (WebKit)', lgpl2, apple), indent, f)
	dumpCompo(compoAndLicenses('WTF (WebKit)', lgpl2), indent, f)
	dumpCompo(compoAndLicenses('WebCore (WebKit)', lgpl2, lgpl21, apple), indent, f)
	indent = indent + 1
	
	dumpCompo(compoAndLicenses('LIBICUIN', icu), indent, f)
	dumpCompo(compoAndLicenses('LIBICUUC', icu), indent, f)
	dumpCompo(compoAndLicenses('Icudt46', icu), indent, f)
	dumpCompo(compoAndLicenses('PThreadVC2', lgpl2), indent, f)
	dumpCompo(compoAndLicenses('ZLIB1', zlib), indent, f)
	dumpCompo(compoAndLicenses('LIBCURL', curl), indent, f)
	dumpCompo(compoAndLicenses('Cairo', lgpl2), indent, f)
	dumpCompo(compoAndLicenses('Pixman', mit), indent, f)
	dumpCompo(compoAndLicenses('LibXml2', mit), indent, f)
	dumpCompo(compoAndLicenses('libjpeg (libjpeg-turbo)', libjpeg), indent, f)
	dumpCompo(compoAndLicenses('libpng', libpng), indent, f)
